
import java.io.*;

public class ImportData {


	private boolean readLabelFile(RandomAccessFile raf){
		boolean flag = false;
		int totalCharNumber = 0;//number of character
		int bytePerChar = 0;
		try {
		
			int bit0 = raf.read();
			int bit1 = raf.read();
		
			totalCharNumber = (bit0&0x000000ff)|((bit1& 0x000000ff)<<8);
			System.out.println("number of character in label file"+totalCharNumber);
			
			bytePerChar = raf.read();
			

			byte[] b = new byte[bytePerChar];
			for(int i = 0; i < totalCharNumber; i++){
				raf.read(b);
				System.out.println(new String(b));
			}
			
			raf.close();
			flag = true;
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		
		
		return flag;
	}
	
	private boolean readVectorFile(RandomAccessFile raf){
		boolean flag = false;
		int totalCharNumber = 0;//number of character
		short[] byteOfChar = null;
		int strNum = 0;//number of stroke per character
		int X = 0;
		int Y = 0;
		try {
			totalCharNumber = (raf.read()&0x000000ff)|((raf.read()& 0x000000ff)<<8)|
			((raf.read()&0x000000ff)<<16)|((raf.read()&0x000000ff)<<24);
		
			System.out.println("number of character in vector file"+totalCharNumber);
			
			//read number of byte for every character
			byteOfChar = new short[totalCharNumber];
			for(int i = 0; i <totalCharNumber; i++ ){
				byteOfChar[i] = (short)(raf.read()|((raf.read()&0xff)<<8));
//				System.out.println("The amount of space character is"+byteOfChar[i]);
			}
			
			
			
			//read content of every character


			for(int i = 0; i <totalCharNumber; i++ ){
				strNum = raf.read();
				int[] numPointPerStr = new int[strNum];
				for(int j = 0; j < strNum; j++ ){
					numPointPerStr[j] = raf.read();
				}
				System.out.println("character "+i+"");
				//To read the coordinate of every stroke
				for(int j = 0; j < strNum; j++ ){
					System.out.println("stroke "+j+"");
					for(int k=0;k< numPointPerStr[j]; k++){
						System.out.println("coordinate "+k+"");
						X = raf.read()&0x00ff;
						Y = raf.read()&0x00ff;
						System.out.println("x:"+X);
						System.out.println("y:"+Y);
					}
				}
			}
			raf.close();
			flag = true;
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		return flag;
	}
	
	private boolean readImageFile(RandomAccessFile raf){
		boolean flag = false;
		
		int totalCharNumber = 0;//number of character
		int high = 0;//image high
		int weight = 0;//image width
	
		byte[] pixGray = null;
		try {
			totalCharNumber = (raf.read()&0x000000ff)|((raf.read()& 0x000000ff)<<8)|
			((raf.read()&0x000000ff)<<16)|((raf.read()&0x000000ff)<<24);
			System.out.println("number of character in image file"+totalCharNumber);
			
			
			high = raf.read();
			weight = raf.read();
			
			System.out.println("image high" + high);
			System.out.println("image width" + weight);
			
			
			pixGray = new byte[weight * high];//put the image in the array
			
			
			//read image of every character in order
			for(int i = 0; i < totalCharNumber; i++){
				
				raf.read(pixGray, 0, weight * high);
				System.out.println("image "+i+"");
				for(int h = 0; h < high; h++){
					for(int w = 0; w < weight; w++){
						/*if(pixGray[h*weight+w]!= -1){
							System.out.print(1);
						}else{
							
							System.out.print(0);
						}*/
						
						System.out.print((pixGray[h*weight+w]+256)%256+"	");
					}
					System.out.println();
				}
			}
			
			raf.close();
			flag = true;
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		return flag;
	}
	

	
	private void process(String path){
		
		RandomAccessFile raf = null;
		try {
			raf = new RandomAccessFile(path,"r");
			if(path.endsWith("labels")){
				//read data of label file
				readLabelFile(raf);
					
			}
			else if(path.endsWith("vectors")){
				//read data of vector file
				readVectorFile(raf);
			}
			else if(path.endsWith("images")){
				//read data of image file
				readImageFile(raf);
			} 
			
			else{
				System.out.println("file path error!");
				return;
			}
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} finally{
			try {
				if(raf != null){
					raf.close();
					raf = null;
				}
			} catch (Exception e) {
				// TODO: handle exception
				e.printStackTrace();
			}
		}
		
		

	}
	/**
	 * @param args
	 * args[0] is the path of experiment data file, for example "D:\\1_aa_vectors"
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub
		ImportData ihd = new ImportData();
		String path = "";
		if(args.length != 1){
			
			System.out.println("Parameter error!");
			System.out.println("The input parameter is the path of experiment data file, for example \"D:\\\\1_aa_vectors\"");
			
		}else{
			
			path = args[0];
			ihd.process(path);
		}
		
		
	}

}

